#define FOG

#define FOG_LIN_MAXDIST 1500.0
#define FOG_EXP2_DENS 0.0013

float getGroundY(in float z)
{
	z = clamp(z, 0.0, TERRAIN_SEA_Z);
	return (z-TERRAIN_SEA_Z)*TERRAIN_GROUND_SLOPE - TERRAIN_GROUND_BELOW_SEA;
}

#if defined(FOG_FUNC_LIN)

float getFogFactor(in mat4 view, in vec4 positionWorld)
{
	vec3 positionView = vec3(view * positionWorld);
	float dist = length(positionView);
	const float maxFogDist = FOG_LIN_MAXDIST/FOG_DENS_MULT;
	float fogFactor = dist/maxFogDist;
	fogFactor = clamp(fogFactor, 0.0, 1.0) * FOG_MAX_FACTOR;
	return fogFactor;
}

#elif defined(FOG_FUNC_EXP2)

float getFogFactor(in mat4 view, in vec4 positionWorld)
{
	vec3 positionView = vec3(view * positionWorld);
	const float densityFactor = FOG_EXP2_DENS*FOG_DENS_MULT;
	const float LOG2INV = 1.442695;
	float dist = length(positionView)*densityFactor;
	float fogFactor = exp2(-dist * dist * LOG2INV);
	fogFactor = FOG_MAX_FACTOR - clamp(fogFactor, 0.0, 1.0) * FOG_MAX_FACTOR;
	return fogFactor;
}

#endif

float getFogFactorGround(float fogFactor, in vec4 positionWorld)
{
	const float groundFogHeight = 12.0;
	const float groundFogDistAdapt = 3.5;
	const float groundFogFactorMax = 0.5;
	const float groundFogLimitFactorZ = 0.8;
	float groundFogFactor = 1.0 - clamp((positionWorld.y-getGroundY(positionWorld.z))/groundFogHeight, 0.0, 1.0);
	float groundFogFactorZ = 1.0 - clamp((positionWorld.z-groundFogLimitFactorZ*TERRAIN_SEA_Z)/((1.0-groundFogLimitFactorZ)*TERRAIN_SEA_Z), 0.0, 1.0);

	fogFactor = clamp(fogFactor*groundFogDistAdapt, 0.0, 1.0);
	return min(groundFogFactorMax, fogFactor * groundFogFactor*groundFogFactorZ) * FOG_MAX_FACTOR;
}


#ifdef FOG_FACTOR_CONST
float getFogFactorConst()
{
	return clamp(FOG_FACTOR_CONST, 0.0, FOG_MAX_FACTOR);
}
#endif


